<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/my-profile.js");

// Metadata informations of this page
$page_title = "My Profile";
$page_slug	= "my-profile";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

$user_id = $_SESSION["USER_ID"];

// Check if user exists...
$user_sql = $dbh->prepare("	SELECT *
							FROM user
							WHERE id = :user_id
							");
					
$user_sql->bindParam(':user_id', $user_id);
$user_sql->execute();
	
$user = $user_sql->fetch();
	
// -- Include the header template
include("templates/headers/global_header.php")
?>

<?php
if($ads_code != "") {
?>
<div class="row">
	<div class="col-md-12">
		<?php
		echo $ads_code;
		?>
	</div>
</div>
<?php
}	
?>

<div class="row">
	
	<div class="inner-container container-profile">
		<a class="btn btn-primary btn-create-quiz" href="create-quiz.php"><i class="em em-computer"></i> Create a Quiz</a>
		<?php
		if($_SESSION["RANK"] == 1) {	
		?>
		<a class="btn btn-danger btn-admin-area" href="admin.php"><i class="em em-closed_lock_with_key"></i> Admin Area</a>
		<?php
		}
		?>		
	</div>
	<div class="inner-container content" id="main-content">
					
		<h3>My Profile</h3>
		
		<div class="content-inner">
			
			<form method="POST" action="" enctype="multipart/form-data" class="form_profile_pic">
				<div class="upload-in-progress alert alert-info">
					<i class="fas fa-circle-notch fa-spin"></i><br>
					Upload in progress...
				</div>
				<div class="profile_picture_container">
					<a href="#">
						<div class="delete_profile_picture" <?php if($user["profile_picture"] == ""): ?>style="display: none;"<?php endif; ?>>
							<i class="fa fa-times"></i>
						</div>
						<img src="<?php if($user["profile_picture"] != ""): ?><?php echo $user["profile_picture"]; ?><?php else: ?>img/default_avatar.jpg<?php endif; ?>" />
					</a>
				</div>
				<input type="file" name="profile_photo" class="profile_photo_input" />
			</form>
			<center><small>Click on the photo to change it</small></center>
			
			<hr />
			
			<form action="" method="post" id="profile-form">
				<div class="qcreator-part-1">
					<div class="form-group form-centered">
						<label>Full Name</label>
						<input value="<?php echo htmlspecialchars($user["fullname"]); ?>" type="text" autocomplete="off" class="form-control fullname" name="fullname" placeholder="Enter your Full Name" />
					</div>
					<div class="form-group form-centered">
						<label>Email</label>
						<input value="<?php echo $user["email"]; ?>" type="email" autocomplete="off" class="form-control email" name="email" placeholder="Enter your Email" />
					</div>
					<div class="alert alert-danger alert-center error-profile">
					                
				    </div>
					<center>
						<button type="submit" class="btn btn-primary edit-usr-btn" href="create-quiz.php">Save Profile <i class="fas fa-check"></i></button>
					</center>
				</div>
				
			</form>
			
			<hr />
			
			<div class="profile_bottom_buttons">
				<a href="logout.php" class="btn btn-sm btn-dark"><i class="em em-zipper_mouth_face"></i> Logout</a>
				<a href="delete-account.php" class="btn btn-sm btn-danger btn-delete-account"><i class="em em--1"></i> Delete Account</a>
			</div>
		
		</div>
		
	</div>
					
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>
			